### 概览

本实验用 can 盒将 PC 机与工智机相连，实现了：1、can盒发送数据，工智机接受数据。2、工智机发送数据，can盒接受数据；本实验是基于 metafacture1.0.4.0 控制与检测工智机收发数据的状态，最终实验目的是验证该工智机是否支持can通讯协议。

下载：🧷**[MetaFacture的CAN通讯](https://resource.helplook.net/docker_production/3648ne/article/1QPQDcZv/attachments/CAN通讯.zip "CAN通讯.zip")**

---

### 软硬件配置

硬件：SX20-01(工智机) can 分析仪（创芯科技）

软件：MetaFacture 1.0.4.0 USB can tool V9.11(can 盒接受与发送数据的软件)

硬件连接示意图

![](https://resource.helplook.net/docker_production/3648ne/article/1QPQDcZv/67162685ba3bb.png)

---

### 实验步骤

（一）新建工程

打开 MetaFacture 软件，新建一个标准工程，设备选择 sinsegye，编程语言可选择结构化文本（ST）。

（二）查看工智机 IP 地址

1\. 将工智机连接网线、电源、显示器、鼠标、键盘，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/1QPQDcZv/6716268612209)

中科时代的工智机内置了Ubuntu 系统或 Windows 系统。

Windows 系统，在开始菜单栏输入 CMD 打开终端命令窗口，输入'ipconfig'。

Ubuntu 系统，在终端中输入'ifconfig'。可在显示器上查看对应网口的 IP 地址。

（三）程序编写

变量定义

![](https://resource.helplook.net/docker_production/3648ne/article/1QPQDcZv/67162688115e6)

将上图中的代码添加至 MetaFacture 中。

代码编写

将如下图代码添加至 MetaFacture 中。

![](https://resource.helplook.net/docker_production/3648ne/article/1QPQDcZv/6716268880983)

（四）添加及使用 Can 库

将” CmpCanBusUtils”库文件安装至 metafacture 中。

点击【菜单栏】中的【工具】-【库存储】，点击安装，在本地中找到文件对应路径即可。

双击”设备树”中的【库管理器】，点击【添加库】，在搜索框中输入【CmpCanBusUtils】， 点击【确定】，即可完成添加。

（五）工智机基本配置

在终端界面连接工智机 IP 地址，本事例 IP 地址为：192.168.110.140。

在终端界面中输入如下命令：

安装 can 工具：sudo apt install can-utils -y

如遇到报错，如下图，应先修改工智机配置文件。

![](https://resource.helplook.net/docker_production/3648ne/article/1QPQDcZv/67162688dfff8.png)

cd /usr/local/etc/SinsegyeRTE/

vim device\_config.yaml

如下图，can0 口的波特率为 250k

![](https://resource.helplook.net/docker_production/3648ne/article/1QPQDcZv/67162689376d9)

sudo vim /etc/apt/sources.list，将下面这四行的注释取消掉，如下图所示。

![](https://resource.helplook.net/docker_production/3648ne/article/1QPQDcZv/67162689ae3df.png)

sudo apt update 更新升级

sudo apt install can-utils -y 再次安装 can 工具

sudo candump can0 执行该命令可验证can 盒与工智机是否可正常通讯，若在终端界面没有输出任何信息，即表明可以正常通讯。

（六）Can 分析仪与工智机连接

如下图，左侧 HSL 为 can1 的接口，右侧HGL 为 can2 的接口。可以根据自己的需要选择 can

口，本事例中选择 can1 口。

![](https://resource.helplook.net/docker_production/3648ne/article/1QPQDcZv/6716268a17a04)

（七）windows 下 CAN 调试工具使用

安装 USB can tool V9.11 工具

点击【菜单栏】中的【设备操作】-【启动设备】，如下图。![](https://resource.helplook.net/docker_production/3648ne/article/1QPQDcZv/6716268a75909.png)

选择设备，注意 索引号的值，连接多个 CAN 盒子时，区分设备使用。该值与工智机中初始化的 can 节点一致，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/1QPQDcZv/6716268ad1c4d.png)

设置 CAN 通道号与波特率

CAN 通道号：与 CAN 盒子接线位置对应波特率：与工智机中 device 配置文件对应

![](https://resource.helplook.net/docker_production/3648ne/article/1QPQDcZv/6716268b3a8ee)

如下左图，can1 口波特率为 250k，那么右图中“波特率”应设置为 250k bps；“选择 can 通道号”为通道 1。

当 USB-CAN tool 工具调试通时，效果如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/1QPQDcZv/6716268ba97e7.png)

（八）MetaFacture 与Can 盒通讯

MetaFacture 发送数据，USB-CAN tool 查看数据

![](https://resource.helplook.net/docker_production/3648ne/article/1QPQDcZv/6716268c13635)在 PLC（PRG）程序中，usiNetId：设置索引号，工智机中的 can 节点对应；uiBaudrate： 设置波特率，对应工智机 /usr/local/etc/SinsegyeRTE/device\_config.yaml 文件中can\_interfaces 下 bitrate 值，在程序中可以修改 usiNetId 和 uiBaudrate 的值，如下图。

设置发送数据 cobID：设置发送的帧 ID pData：设置发送的数据值

如下左图，MetaFacture 设置帧 ID 为 100，数据值为 80、71、76；在 metafacture 中点击【生成代码】-【运行】-【登录】；如下右图，可以看到 Tool 中 ID 号为 0064，数据为 80、71、76，那么可以验证metafacture 发送数据，CAN 接受数据成功。

![](https://resource.helplook.net/docker_production/3648ne/article/1QPQDcZv/6716268c91aac)

二、USB-CAN tool 发送数据，MetaFacture 接受数据

len：查看长度；id：查看帧 ID；datetime：查看时间，需+8 小时；pData1：查看数据值。在数据中输入“11 07 00 00 00 00 00 21”点击“发送数据”，在 MetaFacture-“pData1” 中显示了对应的值，那么可以验证 CAN 发送数据，MetaFacture 接受数据成功，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/1QPQDcZv/6716268cee8f1)

![](https://resource.helplook.net/docker_production/3648ne/article/1QPQDcZv/6716268d80d06)

---

### 结论

如上述步骤可以得出，工智机发送数据给 can 分析仪，Tool 可接收到工智机发送的数据；Tool 发送数据给工智机，MetaFacture 可接收到数据。可以得出该工智机支持can通讯。